---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.41
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 18, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100300 Renamed REL_PRODUCT_CLUSTER_USER with USER_PRODUCT_CLUSTER_STAT (Table name changed)
-- MSW 100300 Renamed NUM_MOVIES_SEEN to TOTAL_PROD_SEEN (Column name changed)
-- MSW 100300 Renamed CALC_E to FRN_OF_PC_SEEN (Column name changed) CHECK WITH BWL
-- MSW 100300 Renamed CALC_R to AVG_PROD_EVAL (Column name changed)
-- MSW 100300 Renamed sp_SEL_NMSER_CALCS to SP_SEL_USER_PC_STAT
-- MSW 100300 Renamed TOTAL_OF_USER_SEEN_PROD to TOTAL_USER_SEEN
-- MSW 100300 Renamed FRN_OF_UC_SEEN_PROD to FRN_OF_UC_SEEN-- MSW 100300 Renamed PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Renamed FRN_OF_UC_ASK_PROD to FRN_OF_UC_EVAL
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Renamed FRN_OF_PC_SEEN to FRN_OF_EVAL_SEEN
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100400 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100500 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100500 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2
-- MSW 100600 Moved sp_INS_ReCalcStats to its own file, ddl_pkg_calc5.sql
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_USER_DATA
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_ALKINDEX_DATA
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100700 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC2
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- AHW 100900 Renamed all "STAT" columns that contained "TOTAL" to "TOT"
-- AHW 100900 Renamed all "STAT" columns that contained "W" to "WGT"
-- AHW 100900 Renamed all "STAT" table names that contained USER_CLUSTER to UC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT_CLUSTER to PC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT to PROD
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT to PROD (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT_CLUSTER to PC (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained USER_CLUSTER to UC (except foreign key references)
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- AHW 101000 Removed CALC_M3, CALC_M4 from select statement in sp_SEL_M_CALCS
-- AHW 101000 Renamed all "STAT" columns that contained FRACTION to FRN
-- MSW 101000 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_M2_By_User
-- MSW 101100 Added column AVG_USER_EVAL to pkg_ALKINDI_RECOMMENDATION.sp_SEL_PROD_BY_USERSCORE
-- AHW 101100 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_Prod_By_UC_AVG_EVAL
-- MSW 101100 Added pkg_ALKINDI_RECOMMENDATION.sp_Flush_Recommendation_Table  This sp is overloaded.  inputs are a data or a date and a user_id
-- MSW 101100 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_Prod_By_UserScore, removed subquery by product_cluster_id because product_cluster_id was added to rel_user_cluster
-- MSW 101100 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_M2_By_User evaluation_scale_id >0 (formerly 'NOT IN (-1,0)')
-- MSW 101100 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_Prod_By_UC_AVG_EVAL, removed subquery by product_cluster_id because product_cluster_id was added to rel_user_cluster
-- MSW 101100 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_M_CALCS, removed subquery by product_cluster_id because product_cluster_id was added to rel_user_cluster
-- MSW 101200 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_PC_STAT, removed join with product_cluster for active product clusters
-- MSW 101200 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_CountProd_In_PC, changed query to select from pc_stat table instead of counting from rel_product_cluster
-- MSW 101200 Renamed pkg_ALKINDI_RECOMMENDATION.sp_SEL_AVG_PRODEVALS_BY_PROD to sp_SEL_ALL_PROD_AVG_EVAL
-- MSW 101200 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALL_PROD_AVG_EVAL to query from prod_stat table instead of evaluation
-- MSW 101200 Removed pkg_ALKINDI_RECOMMENDATION.sp_SEL_All_PC_Status
-- MSW 101300 Added pkg_ALKINDI_RECOMMENDATION.PROCEDURE sp_SEL_PC_DATA_BY_USER
-- MSW 101300 Added pkg_ALKINDI_RECOMMENDATION.PROCEDURE sp_SEL_SCORING_FUNCTION_WEIGHT
-- MSW 101300 Added pkg_ALKINDI_RECOMMENDATION.PROCEDURE sp_SEL_AVG_EVAL_BY_PROD
-- MSW 101300 Added pkg_ALKINDI_RECOMMENDATION.PROCEDURE sp_SEL_PROD_BY_USER_PC_SF
-- MSW 101500 Renamed all references to PROD_UC_STAT.PROD_EVAL_MEAN_BY_UC to PROD_UC_STAT.AVG_PROD_EVAL_BY_UC because of table structure change
-- MSW 101600 Removed pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA
-- MSW 101600 Added pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_BY_USER
-- MSW 101600 Tweaked pkg_ALKINDI_RECOMMENDATION.sp_SEL_CountSeen_In_UC to remove subqueries
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 101800 Removed pkg_ALKINDI_RECOMMENDATION.sp_SEL_Prod_By_UC_SCORE because it is not used anymore (moved to ddl_archive.txt)
-- MSW 101800 Removed pkg_ALKINDI_RECOMMENDATION.sp_SEL_Prod_By_UserScore because it is not used anymore (moved to ddl_archive.txt)
-- MSW 101800 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PROD_BY_USER_PC_SF to return product_type_id as well as product_id
-- MSW 101800 Removed pkg_ALKINDI_RECOMMENDATION.sp_SEL_M_Calcs because it is not used anymore (moved to ddl_archive.txt)
-- MSW 101800 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PC_DATA_BY_USER to retrieve bi
-- MSW 101800 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PRED_EVAL_BY_USER_PROD to retrieve bi
-- MSW 101800 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PROD_BY_USER_PC_SF to not return product_ids that have already been recommended
-- MSW 101800 Commented out pkg_ALKINDI_RECOMMENDATION.sp_SEL_AVG_PROD_EVAL_BY_PROD, Delete once positive it isn't used anywhere
-- MSW 101900 Commented out pkg_ALKINDI_RECOMMENDATION.COUNT_EVAL_BY_USER (FUNCTION), Delete once positive it isn't used anywhere
-- MSW 101900 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PC_DATA_BY_USER, removed hard-coded user_id
-- MSW 101900 Changed pkg_ALKINDI_RECOMMENDATION.sp_SEL_PC_DATA_BY_USER, Added RUC.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID


---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------


CREATE OR REPLACE PACKAGE pkg_ALKINDI_RECOMMENDATION
AS
  TYPE RECOMMENDATION_cursor_type is REF CURSOR;

--  FUNCTION COUNT_EVAL_BY_USER (
--	i_USER_ID						NUMBER,
--	i_PRODUCT_CLUSTER_ID				NUMBER)	RETURN NUMBER;

  PROCEDURE sp_SEL_USER_PC_STAT(								-- BK092400
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_CountProd_In_PC(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_CountSeen_In_UC(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_USER(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);
  
  PROCEDURE sp_SEL_ALL_PROD_AVG_EVAL(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_M2_By_User(	
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_INS_Recs(
     i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN		RECOMMENDATION.PRODUCT_ID%TYPE,
     i_PREDICTED_EVALUATION		IN		RECOMMENDATION.PREDICTED_EVALUATION%TYPE,
     i_SCORING_FUNCTION_ID		IN		RECOMMENDATION.SCORING_FUNCTION_ID%TYPE);

  PROCEDURE sp_SEL_Prod_By_UC_AVG_EVAL(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_Flush_Recommendation_Table(
	i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_Flush_Recommendation_Table(
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER);

--  PROCEDURE sp_SEL_AVG_PROD_EVAL_BY_PROD(
--	i_PRODUCT_ID			IN		PROD_STAT.PRODUCT_ID%TYPE,
--	o_AVG_USER_EVAL			OUT		PROD_STAT.AVG_USER_EVAL%TYPE,
--	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_PC_DATA_BY_USER(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_SCORING_FUNCTION_WEIGHT(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_AVG_EVAL_BY_PROD(
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_AVG_PROD_EVAL			OUT		NUMBER);

  PROCEDURE sp_SEL_PROD_BY_USER_PC_SF(
	i_USER_ID				IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_SF_COLUMN_NAME			IN		VARCHAR2,
	i_PRODUCT_CLUSTER_ID		IN		REL_USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_A1					IN		NUMBER,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_PRED_EVAL_BY_USER_PROD(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_PRODUCT_ID			IN		PROD_UC_STAT.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_ALKINDEX_BY_USER (
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_RECOMMENDATION;
/

-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_RECOMMENDATION
AS

-- BK092400 - Used by Recommendation Manager
-- Search user's product cluster statistics by selecting product_cluster_id, total_prod_seen and avg_prod_eval values 
-- from USER_PC_STAT 

  PROCEDURE sp_SEL_USER_PC_STAT(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT USER_PC_STAT.PRODUCT_CLUSTER_ID
	     , USER_PC_STAT.TOT_PROD_SEEN
	     , USER_PC_STAT.FRN_OF_EVAL_SEEN
	     , USER_PC_STAT.AVG_PROD_EVAL
	  FROM USER_PC_STAT
	 WHERE USER_PC_STAT.USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6556;						-- general errors when selecting user's product
												-- cluster statistics
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_USER_PC_STAT;

-- ==========================================================================================

-- BK092400 - Selects Number of Products in each Product Cluster
-- Searching the number of products in each product cluster by selecting product_cluster_id and tot_prod_in_pc 
-- from PC_STAT without passing in any values

  PROCEDURE sp_SEL_CountProd_In_PC(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PRODUCT_CLUSTER_ID, TOT_PROD_IN_PC
	  FROM PC_STAT;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6557;						-- general errors when selecting the number of
												-- products in each product cluster 
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_CountProd_In_PC;

-- ==========================================================================================
-- Searching the number of times that users have seen this product and their avg prod eval
-- for the given user cluster

  PROCEDURE sp_SEL_CountSeen_In_UC(							-- MSW 092500, for BWL
 	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_ID			IN		EVALUATION.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PUCS.PRODUCT_CLUSTER_ID
	     , PUCS.TOT_USER_SEEN
	     , PUCS.AVG_PROD_EVAL_BY_UC
	  FROM PROD_UC_STAT PUCS
       WHERE PUCS.PRODUCT_ID = i_PRODUCT_ID
	   AND PUCS.USER_CLUSTER_ID IN 
     (SELECT USER_CLUSTER_ID 
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = i_USER_ID);

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6558;						 -- general errors when selecting the number of 
											       -- times users have seen this product in the specified
		CLOSE o_RECOMMENDATION_cursor_type;					 -- user cluster
 END sp_SEL_CountSeen_In_UC;

-- ==========================================================================================
-- Selecting the average of product evaluations by users without passing in any values and 
-- grouping the result by user_id
 
  PROCEDURE sp_SEL_AVG_PRODEVALS_BY_USER(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN 
	o_ERROR_CODE := 0; 

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT EVALUATION.USER_ID
	     , AVG(EVALUATION_SCALE_ID)
	  FROM EVALUATION
	 WHERE EVALUATION_SCALE_ID >= 1
    GROUP BY USER_ID;

  EXCEPTION
  	WHEN OTHERS THEN
      o_ERROR_CODE  := 6568;							-- general errors when selecting the average of product
      CLOSE o_RECOMMENDATION_cursor_type;					-- evaluations by users
  END sp_SEL_AVG_PRODEVALS_BY_USER; 

-- ==========================================================================================
-- Selecting the average of all user evaluations of all products from a product stat table
 
  PROCEDURE sp_SEL_ALL_PROD_AVG_EVAL(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
  IS BEGIN 
	o_ERROR_CODE := 0; 

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PRODUCT_ID
	     , AVG_USER_EVAL
	  FROM PROD_STAT;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := 6569;							 -- general errors when selecting the average of all user
      CLOSE o_RECOMMENDATION_cursor_type;					 -- evaluations of all products
  END sp_SEL_ALL_PROD_AVG_EVAL; 

-- ==========================================================================================

-- selecting the M2 calculations from EVALUATION and PROD_UC_STAT by squaring (evaluations subtracted by
-- the average of product evaluations given a user_cluster), then divided by the sum of sigma_squared 

  PROCEDURE sp_SEL_M2_By_User(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT SUM(POWER(E.EVALUATION_SCALE_ID - S.AVG_PROD_EVAL_BY_UC, 2))/SUM(S.SIGMA_SQUARED)
	  FROM EVALUATION E
	     , PROD_UC_STAT S
	 WHERE S.USER_CLUSTER_ID IN
     (SELECT USER_CLUSTER_ID
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID= i_USER_ID)
	   AND E.USER_ID = i_USER_ID
	   AND S.PRODUCT_ID = E.PRODUCT_ID
	   AND E.EVALUATION_SCALE_ID >= 1;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_M2_By_User;

-- ==========================================================================================
-- Inserting records such as user_id, product_id, predicted_evaluation, scoring_function_id, 
-- recommendation_timestamp into the RECOMMENDATION table 

  PROCEDURE sp_INS_Recs(
     i_USER_ID				IN	RECOMMENDATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN	RECOMMENDATION.PRODUCT_ID%TYPE,
     i_PREDICTED_EVALUATION		IN	RECOMMENDATION.PREDICTED_EVALUATION%TYPE,
     i_SCORING_FUNCTION_ID		IN	RECOMMENDATION.SCORING_FUNCTION_ID%TYPE)

   IS 
	ERR_NUM	NUMBER; 
	ERR_MSG 	VARCHAR2(255);
   BEGIN
	INSERT INTO RECOMMENDATION(USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP)
      VALUES (i_USER_ID, i_PRODUCT_ID, i_PREDICTED_EVALUATION, i_SCORING_FUNCTION_ID, sysdate);

  EXCEPTION
	WHEN OTHERS THEN
	err_num := SQLCODE; 
	err_msg := SQLERRM;
	INSERT INTO errors
	VALUES (err_num, err_msg); 

 END sp_INS_Recs;

-- ==========================================================================================
-- selecting products by user cluster and then order by the average product evaluations by user cluster in a 
-- descending order 

  PROCEDURE sp_SEL_Prod_By_UC_AVG_EVAL(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	i_PRODUCT_CLUSTER_ID		IN		USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT /*+ PUSH_SUBQ */ 
		 PRODUCT_ID
	  FROM PROD_UC_STAT
	 WHERE USER_CLUSTER_ID =
     (SELECT USER_CLUSTER_ID
	  FROM REL_USER_CLUSTER
	 WHERE USER_ID = i_USER_ID
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID)
    ORDER BY AVG_PROD_EVAL_BY_UC DESC;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6554;
		CLOSE o_RECOMMENDATION_cursor_type;
 END sp_SEL_Prod_By_UC_AVG_EVAL;


-- ==========================================================================================
-- Flushing the recommendation table by first inserting records into the RECOMMENDATION_LOG and then deleting 
-- the old/existing records, given a supplied user_id and date

  PROCEDURE sp_Flush_Recommendation_Table(
	i_USER_ID				IN		RECOMMENDATION.USER_ID%TYPE,
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	INSERT
	  INTO RECOMMENDATION_LOG (USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, LOG_TIMESTAMP)
     (SELECT USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, sysdate
	  FROM RECOMMENDATION
	 WHERE USER_ID = i_USER_ID
	   AND RECOMMENDATION_TIMESTAMP < i_DATE);

	DELETE
	  FROM RECOMMENDATION
	 WHERE USER_ID = i_USER_ID
	   AND RECOMMENDATION_TIMESTAMP < i_DATE;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;


  END sp_Flush_Recommendation_Table;
-- ==========================================================================================
-- Flushing the recommendationt table by only passing in the date but no user_id, and then delete the old records 

  PROCEDURE sp_Flush_Recommendation_Table(
	i_DATE				IN		DATE,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	INSERT
	  INTO RECOMMENDATION_LOG (USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, LOG_TIMESTAMP)
     (SELECT USER_ID, PRODUCT_ID, PREDICTED_EVALUATION, SCORING_FUNCTION_ID, RECOMMENDATION_TIMESTAMP, sysdate
	   FROM RECOMMENDATION
	  WHERE RECOMMENDATION_TIMESTAMP < i_DATE);

	DELETE
	  FROM RECOMMENDATION
	 WHERE RECOMMENDATION_TIMESTAMP < i_DATE;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;


  END sp_Flush_Recommendation_Table;

-- ==========================================================================================
-- selecting the average product evaluations of a given product from a pre-calc stat table
-- Commented out 101800, Delete once positive this isn't used anywhere
--  PROCEDURE sp_SEL_AVG_PROD_EVAL_BY_PROD(
--	i_PRODUCT_ID			IN		PROD_STAT.PRODUCT_ID%TYPE,
--	o_AVG_USER_EVAL			OUT		PROD_STAT.AVG_USER_EVAL%TYPE,
--	o_ERROR_CODE			OUT		NUMBER)

--  IS BEGIN
--	o_ERROR_CODE	:= 0;

--	SELECT AVG_USER_EVAL INTO o_AVG_USER_EVAL
--	  FROM PROD_STAT
--	 WHERE PRODUCT_ID = i_PRODUCT_ID;

--  EXCEPTION
--	WHEN OTHERS THEN
--		o_ERROR_CODE	:= -1;

--  END sp_SEL_AVG_PROD_EVAL_BY_PROD;

-- ==========================================================================================
-- Function to calculate the  total number of products that a specified user has evaluated in a specified
-- Product Cluster
-- Commented out 101900, Delete once positive this isn't used anywhere

--  FUNCTION COUNT_EVAL_BY_USER (
--	i_USER_ID						NUMBER,
--	i_PRODUCT_CLUSTER_ID				NUMBER)	RETURN NUMBER
--   IS 
--	v_RESULT		NUMBER;
--   BEGIN
--	SELECT COUNT (E.EVALUATION_SCALE_ID) INTO v_RESULT
--	  FROM EVALUATION E, REL_PRODUCT_CLUSTER R
--	 WHERE E.USER_ID = i_USER_ID
--	   AND R.PRODUCT_ID = E.PRODUCT_ID(+)
--         AND R.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID;
--
--	RETURN v_RESULT;
--  END COUNT_EVAL_BY_USER;


-- ==========================================================================================

-- selects product cluster data by user
-- Retrieves total evaluations by user by  PC
-- Retrieves weighted total products by PC
-- Retrieves fraction of products that the user has seen of the ones that the user evaluated by PC
-- Retrieves average evaluation by PC
-- Retrieves the bi for the user cluster subgroup that the user belongs to by PC
-- grouping the result by product_cluster_id
-- MSW 101800 Added bi to select statement
-- MSW 101800 This query requires us to cross many dimensions.  Real time use of this query will definitely
-- cause problems.  These stats could be stored in a precalculated stat table and query would be quick and simple
-- MSW 101900 Added RUC.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
  PROCEDURE sp_SEL_PC_DATA_BY_USER(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR


	SELECT R.PRODUCT_CLUSTER_ID
	     , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,5,1,6,1,0)) AS fi
	     , S.WGT_TOT_PROD_IN_PC AS ni
	     , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,5,1,6,1,0))/COUNT(E.EVALUATION_SCALE_ID) as ei
	     , SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,2,3,3,4,4,5,5,6,6,0))/SUM(DECODE(E.EVALUATION_SCALE_ID,1,1,2,1,3,1,4,1,5,1,6,1,0)) AS ri, bi
	  FROM EVALUATION E, REL_PRODUCT_CLUSTER R, PC_STAT S, REL_USER_CLUSTER RUC, ALKINDEX_STAT A
	 WHERE A.USER_CLUSTER_SUBGROUP_INDEX = RUC.USER_CLUSTER_SUBGROUP_INDEX
	   AND E.USER_ID = RUC.USER_ID
	   AND R.PRODUCT_ID = E.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
	   AND E.USER_ID = i_USER_ID
	   AND R.PRODUCT_CLUSTER_ID = A.PRODUCT_CLUSTER_ID
	   AND RUC.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    GROUP BY R.PRODUCT_CLUSTER_ID, S.WGT_TOT_PROD_IN_PC, A.BI;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_PC_DATA_BY_USER;

-- ==========================================================================================

-- selecting all scoring function ids and their weight without passing in any values

  PROCEDURE sp_SEL_SCORING_FUNCTION_WEIGHT(
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN

	o_ERROR_CODE	:= 0;
	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT SCORING_FUNCTION_ID, SCORING_FUNCTION_WEIGHT
	  FROM SCORING_FUNCTION;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_SCORING_FUNCTION_WEIGHT;

-- ==========================================================================================

-- selecting the average evaluations of a specified product

  PROCEDURE sp_SEL_AVG_EVAL_BY_PROD(
	i_PRODUCT_ID		IN		EVALUATION.PRODUCT_ID%TYPE,
	o_AVG_PROD_EVAL		OUT		NUMBER)
   IS BEGIN

	SELECT AVG_USER_EVAL INTO o_AVG_PROD_EVAL
	  FROM PROD_STAT
	 WHERE PRODUCT_ID = i_PRODUCT_ID;

   END sp_SEL_AVG_EVAL_BY_PROD;

-- ==========================================================================================


-- selecting products by the scoring functions in a given user's product cluster  

  PROCEDURE sp_SEL_PROD_BY_USER_PC_SF(
	i_USER_ID				IN		REL_USER_CLUSTER.USER_ID%TYPE,
	i_SF_COLUMN_NAME			IN		VARCHAR2,
	i_PRODUCT_CLUSTER_ID		IN		REL_USER_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_A1					IN		NUMBER,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS 
	v_SQL VARCHAR2(1000) ;
   BEGIN

	o_ERROR_CODE	:= 0;

	v_SQL :='SELECT PRODUCT_ID, PRODUCT_TYPE_ID FROM PROD_UC_STAT WHERE USER_CLUSTER_ID = (SELECT USER_CLUSTER_ID FROM REL_USER_CLUSTER WHERE USER_ID = '
		|| i_USER_ID
		|| ' and PRODUCT_CLUSTER_ID = '
		|| i_PRODUCT_CLUSTER_ID
		|| ') AND AVG_PROD_EVAL_BY_UC > '
		|| i_A1
		|| ' AND PRODUCT_ID NOT IN (SELECT PRODUCT_ID FROM EVALUATION WHERE USER_ID='
		|| i_USER_ID
		|| ')'
		|| ' AND PRODUCT_ID NOT IN (SELECT PRODUCT_ID FROM RECOMMENDATION WHERE USER_ID='
		|| i_USER_ID
		|| ')'
		|| ' ORDER BY '
		|| i_SF_COLUMN_NAME
		|| ' DESC';

OPEN o_RECOMMENDATION_cursor_type FOR v_SQL;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_PROD_BY_USER_PC_SF;

-- ==========================================================================================

-- selecting the predicted evaluations stats by selecting the product_cluster_id, the avg_prod_eval_by_uc and the wgt_tot_prod_in_pc
-- from the PROD_UC_STAT and the PC_STAT tables
-- MSW 101800, Added bi to select statement

  PROCEDURE sp_SEL_PRED_EVAL_BY_USER_PROD(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	i_PRODUCT_ID			IN		PROD_UC_STAT.PRODUCT_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT PUCS.PRODUCT_CLUSTER_ID, BI, PUCS.AVG_PROD_EVAL_BY_UC as ri, PCS.WGT_TOT_PROD_IN_PC as ni
	  FROM PROD_UC_STAT PUCS, PC_STAT PCS, REL_USER_CLUSTER RUC, ALKINDEX_STAT A
	 WHERE PUCS.PRODUCT_CLUSTER_ID = PCS.PRODUCT_CLUSTER_ID
	   AND RUC.USER_CLUSTER_ID = PUCS.USER_CLUSTER_ID
	   AND RUC.USER_CLUSTER_SUBGROUP_INDEX = A.USER_CLUSTER_SUBGROUP_INDEX
	   AND RUC.USER_ID = i_USER_ID
	   AND PRODUCT_ID = i_PRODUCT_ID;
  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_PRED_EVAL_BY_USER_PROD;

-- ==========================================================================================

  PROCEDURE sp_SEL_ALKINDEX_BY_USER (
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_RECOMMENDATION_cursor_type	OUT		RECOMMENDATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_RECOMMENDATION_cursor_type FOR

	SELECT S.PRODUCT_CLUSTER_ID, S.NI, COUNT(E.EVALUATION_SCALE_ID) AS FI, S.BBI, S.BI
	  FROM ALKINDEX_STAT S, EVALUATION E, REL_USER_CLUSTER R
	 WHERE S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
	   AND S.USER_CLUSTER_SUBGROUP_INDEX = R.USER_CLUSTER_SUBGROUP_INDEX
	   AND R.USER_CLUSTER_ID = S.USER_CLUSTER_ID
	   AND E.USER_ID = i_USER_ID
	   AND R.USER_ID = E.USER_ID
    GROUP BY S.PRODUCT_CLUSTER_ID, S.NI, S.BBI, S.BI;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_RECOMMENDATION_cursor_type;
  END sp_SEL_ALKINDEX_BY_USER;

END pkg_ALKINDI_RECOMMENDATION;
/

SHOW ERRORS
